/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.soo.dtoc;

import com.ibm.hwmca.fw.soo.dtoc.decode;
import com.ibm.hwmca.fw.soo.dtoc.master;
import com.ibm.hwmca.fw.soo.dtoc.receiv;
import com.ibm.hwmca.fw.soo.dtoc.sender;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;

final class interp
implements Runnable,
ImageObserver {
    private final String copyright = "(c) Copyright IBM Corp.  1997, 1998.  All rights reserved.";
    private volatile Thread runner = null;
    master painter;
    decode unpack;
    receiv input;
    sender output;
    Component component;
    Graphics screen;
    int screenWidth;
    int screenHeight;
    int cacheCount;
    final int flushCount = 256;
    final int maxImageSize = 16384;
    int[] screenArray = new int[16640];
    int drawImageSize;
    final byte[] redPaletteNS = new byte[]{0, -96, 0, -96, 0, -96, 0, -50, -96, -1, 0, -1, 0, -1, 0, -1};
    final byte[] greenPaletteNS = new byte[]{0, 0, -96, -96, 0, 0, -96, -50, -96, 0, -1, -1, 0, 0, -1, -1};
    final byte[] bluePaletteNS = new byte[]{0, 0, 0, 0, -96, -96, -96, -50, -96, 0, 0, 0, -1, -1, -1, -1};
    int[] vgaColorRGBNS = new int[]{-16777216, -6750208, -16738048, -6711040, -16777063, -6750055, -16737895, -3355444, -6710887, -65536, -16711936, -256, -16776961, -65281, -16711681, -1};
    int[] vgaColorGrayNS = new int[]{-16777216, -6710887, -3355444, -1};
    final byte[] redPaletteIE = new byte[]{0, -121, 0, -121, 0, -121, 0, -64, -121, -1, 0, -1, 0, -1, 0, -1};
    final byte[] greenPaletteIE = new byte[]{0, 0, -121, -121, 0, 0, -121, -64, -121, 0, -1, -1, 0, 0, -1, -1};
    final byte[] bluePaletteIE = new byte[]{0, 0, 0, 0, -121, -121, -121, -64, -121, 0, 0, 0, -1, -1, -1, -1};
    int[] vgaColorRGBIE = new int[]{-16777216, -7929856, -16742656, -7895296, -16777081, -7929721, -16742521, -4144960, -7895161, -65536, -16711936, -256, -16776961, -65281, -16711681, -1};
    int[] vgaColorGrayIE = new int[]{-16777216, -7895161, -4144960, -1};
    final byte[] redPaletteOther = new byte[]{0, -128, 0, -128, 0, -128, 0, -64, -128, -1, 0, -1, 0, -1, 0, -1};
    final byte[] greenPaletteOther = new byte[]{0, 0, -128, -128, 0, 0, -128, -64, -128, 0, -1, -1, 0, 0, -1, -1};
    final byte[] bluePaletteOther = new byte[]{0, 0, 0, 0, -128, -128, -128, -64, -128, 0, 0, 0, -1, -1, -1, -1};
    int[] vgaColorRGBOther = new int[]{-16777216, -8388608, -16744448, -8355840, -16777088, -8388480, -16744320, -4144960, -8355712, -65536, -16711936, -256, -16776961, -65281, -16711681, -1};
    int[] vgaColorGrayOther = new int[]{-16777216, -8355712, -4144960, -1};
    byte[] redPalette = new byte[16];
    byte[] greenPalette = new byte[16];
    byte[] bluePalette = new byte[16];
    Color[] vgaColor = new Color[16];
    Color[] svgaColor = new Color[256];
    int[] vgaColorRGB = new int[16];
    int[] vgaColorGray = new int[4];
    int[] svgaColorRGB = new int[256];
    byte[] patternBuffer = new byte[8];
    short[] param = new short[16];
    boolean fTerminate;
    public boolean fAvailable;
    public Boolean fDrawn = new Boolean(false);
    public int left;
    public int right;
    public int top;
    public int bottom;
    int currentLeft;
    int currentRight;
    int currentTop;
    int currentBottom;
    private static final String TRACE_MASKT = "XDTCINTT";
    private static final String TRACE_MASKF = "XDTCINTF";
    private static final String TRACE_MASKD = "XDTCINTD";

    interp() {
    }

    public void initialize(receiv r, sender s, decode d, master m, int width, int height) {
        this.runner = null;
        this.input = r;
        this.output = s;
        this.unpack = d;
        this.painter = m;
        this.component = m;
        this.screen = this.painter.bufferedScreen;
        this.screenWidth = width;
        this.screenHeight = height;
        this.fTerminate = false;
        this.fAvailable = false;
        this.drawImageSize = 16384;
        int cnt = 0;
        int red = 0;
        while (red <= 255) {
            int green = 0;
            while (green <= 255) {
                int blue = 0;
                while (blue <= 255) {
                    this.svgaColorRGB[cnt] = 0xFF000000 | red << 16 | green << 8 | blue;
                    this.svgaColor[cnt++] = new Color(red, green, blue);
                    blue += 51;
                }
                green += 51;
            }
            red += 51;
        }
        while (cnt < 256) {
            this.svgaColorRGB[cnt] = -16777216;
            this.svgaColor[cnt++] = new Color(0, 0, 0);
        }
        switch (this.painter.nBrowser) {
            case 0: {
                cnt = 0;
                while (cnt < 16) {
                    this.redPalette[cnt] = this.redPaletteNS[cnt];
                    this.greenPalette[cnt] = this.greenPaletteNS[cnt];
                    this.bluePalette[cnt] = this.bluePaletteNS[cnt];
                    this.vgaColorRGB[cnt] = this.vgaColorRGBNS[cnt];
                    ++cnt;
                }
                cnt = 0;
                while (cnt < 4) {
                    this.vgaColorGray[cnt] = this.vgaColorGrayNS[cnt];
                    ++cnt;
                }
                break;
            }
            case 1: {
                cnt = 0;
                while (cnt < 16) {
                    this.redPalette[cnt] = this.redPaletteIE[cnt];
                    this.greenPalette[cnt] = this.greenPaletteIE[cnt];
                    this.bluePalette[cnt] = this.bluePaletteIE[cnt];
                    this.vgaColorRGB[cnt] = this.vgaColorRGBIE[cnt];
                    ++cnt;
                }
                cnt = 0;
                while (cnt < 4) {
                    this.vgaColorGray[cnt] = this.vgaColorGrayIE[cnt];
                    ++cnt;
                }
                break;
            }
            default: {
                cnt = 0;
                while (cnt < 16) {
                    this.redPalette[cnt] = this.redPaletteOther[cnt];
                    this.greenPalette[cnt] = this.greenPaletteOther[cnt];
                    this.bluePalette[cnt] = this.bluePaletteOther[cnt];
                    this.vgaColorRGB[cnt] = this.vgaColorRGBOther[cnt];
                    ++cnt;
                }
                cnt = 0;
                while (cnt < 4) {
                    this.vgaColorGray[cnt] = this.vgaColorGrayOther[cnt];
                    ++cnt;
                }
                break block0;
            }
        }
        cnt = 0;
        while (cnt < 16) {
            this.vgaColor[cnt] = new Color(this.redPalette[cnt] & 0xFF, this.greenPalette[cnt] & 0xFF, this.bluePalette[cnt] & 0xFF);
            ++cnt;
        }
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.painter.trace(1, TRACE_MASKT, "-> terminate");
        if (this.runner != null) {
            this.runner = null;
            this.fTerminate = true;
            Boolean bl = this.fDrawn;
            synchronized (bl) {
                this.fDrawn.notify();
            }
        }
        this.painter.trace(1, TRACE_MASKT, "<- terminate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.painter.trace(2, TRACE_MASKT, "-> run");
        while (this.runner != null && !this.input.isAvailable()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.screenWidth == 0 && this.screenHeight == 0) {
            this.painter.stop();
            this.painter.trace(2, TRACE_MASKT, "<- run; invalid initial packet");
            return;
        }
        this.top = 0;
        this.left = 0;
        this.right = this.screenWidth - 1;
        this.bottom = this.screenHeight - 1;
        this.screen.setColor(new Color(0, 0, 0));
        this.screen.fillRect(0, 0, this.screenWidth, this.screenHeight);
        while (this.runner != null && !this.fTerminate) {
            this.bottom = 0;
            this.right = 0;
            this.left = this.screenWidth;
            this.top = this.screenHeight;
            while (this.runner != null && !this.input.isAvailable()) {
                boolean fDraw = false;
                if (fDraw) break;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.cacheCount = 256;
            while (this.cacheCount > 0 && this.input.isAvailable()) {
                this.update();
                this.combineArea();
                --this.cacheCount;
            }
            Boolean bl = this.fDrawn;
            synchronized (bl) {
                this.fAvailable = true;
                if (this.runner != null) {
                    int width = this.right - this.left + 1;
                    int height = this.bottom - this.top + 1;
                    this.painter.repaint(this.left, this.top, width, height);
                    try {
                        this.fDrawn.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
        this.painter.trace(2, TRACE_MASKT, "<- run");
    }

    public void update() {
        if (!this.fTerminate) {
            byte data = this.input.getByte();
            block0 : switch (data & 0xF) {
                case 1: {
                    switch (data >> 4) {
                        case 1: {
                            this.painter.reload();
                            break block0;
                        }
                    }
                    this.painter.disconnect();
                    break;
                }
                case 2: {
                    this.input.getShorts(this.param, 3);
                    this.solidPel(this.param[0] + ((this.param[2] & 0xF) << 8), this.param[1] + ((this.param[2] & 0xF0) << 4), data >> 4 & 0xF);
                    break;
                }
                case 3: {
                    this.input.getShorts(this.param, 6);
                    this.solidRect(this.param[0] + ((this.param[2] & 0xF) << 8), this.param[1] + ((this.param[2] & 0xF0) << 4), this.param[3] + ((this.param[5] & 0xF) << 8), this.param[4] + ((this.param[5] & 0xF0) << 4), data >> 4 & 0xF);
                    break;
                }
                case 4: {
                    this.input.getShorts(this.param, 6);
                    this.unpackedColor256(this.param[0] + ((this.param[2] & 0xF) << 8), this.param[1] + ((this.param[2] & 0xF0) << 4), this.param[3] + ((this.param[5] & 0xF) << 8), this.param[4] + ((this.param[5] & 0xF0) << 4));
                    break;
                }
                case 5: {
                    this.input.getShorts(this.param, 6);
                    this.packedColor256(this.param[0] + ((this.param[2] & 0xF) << 8), this.param[1] + ((this.param[2] & 0xF0) << 4), this.param[3] + ((this.param[5] & 0xF) << 8), this.param[4] + ((this.param[5] & 0xF0) << 4));
                    break;
                }
                case 6: {
                    this.input.getShorts(this.param, 4);
                    this.solidPel256(this.param[0] + ((this.param[2] & 0xF) << 8), this.param[1] + ((this.param[2] & 0xF0) << 4), this.param[3]);
                    break;
                }
                case 7: {
                    this.input.getShorts(this.param, 7);
                    this.solidRect256(this.param[0] + ((this.param[2] & 0xF) << 8), this.param[1] + ((this.param[2] & 0xF0) << 4), this.param[3] + ((this.param[5] & 0xF) << 8), this.param[4] + ((this.param[5] & 0xF0) << 4), this.param[6]);
                    break;
                }
                case 8: {
                    this.input.getShorts(this.param, 8);
                    this.opaqueMono2(this.param[0] + ((this.param[2] & 0xF) << 8), this.param[1] + ((this.param[2] & 0xF0) << 4), this.param[3] + ((this.param[5] & 0xF) << 8), this.param[4] + ((this.param[5] & 0xF0) << 4), this.param[6], this.param[7]);
                    break;
                }
                case 10: {
                    this.input.getShorts(this.param, 7);
                    this.opaqueMono(this.param[0] + ((this.param[2] & 0xF) << 8), this.param[1] + ((this.param[2] & 0xF0) << 4), this.param[3] + ((this.param[5] & 0xF) << 8), this.param[4] + ((this.param[5] & 0xF0) << 4), data >> 4 & 0xF, this.param[6] & 0xF);
                    break;
                }
                case 11: {
                    this.input.getShorts(this.param, 6);
                    this.transMono(this.param[0] + ((this.param[2] & 0xF) << 8), this.param[1] + ((this.param[2] & 0xF0) << 4), this.param[3] + ((this.param[5] & 0xF) << 8), this.param[4] + ((this.param[5] & 0xF0) << 4), data >> 4 & 0xF);
                    break;
                }
                case 12: {
                    this.input.getShorts(this.param, 6);
                    this.opaqueColor(this.param[0] + ((this.param[2] & 0xF) << 8), this.param[1] + ((this.param[2] & 0xF0) << 4), this.param[3] + ((this.param[5] & 0xF) << 8), this.param[4] + ((this.param[5] & 0xF0) << 4));
                    break;
                }
                case 14: {
                    this.input.getShorts(this.param, 6);
                    this.packedColor(this.param[0] + ((this.param[2] & 0xF) << 8), this.param[1] + ((this.param[2] & 0xF0) << 4), this.param[3] + ((this.param[5] & 0xF) << 8), this.param[4] + ((this.param[5] & 0xF0) << 4));
                    break;
                }
                case 15: {
                    this.input.getShorts(this.param, 6);
                    this.packedGray(this.param[0] + ((this.param[2] & 0xF) << 8), this.param[1] + ((this.param[2] & 0xF0) << 4), this.param[3] + ((this.param[5] & 0xF) << 8), this.param[4] + ((this.param[5] & 0xF0) << 4));
                    break;
                }
                default: {
                    this.output.debugOut((byte)15);
                    this.output.debugOut((byte)(data & 0xF));
                    this.output.debugOut((byte)(data >> 4));
                    this.painter.disconnect();
                }
            }
        }
    }

    void invertLine(int x1, int y1, int x2, int y2, int color) {
        this.screen.setXORMode(this.vgaColor[0]);
        this.screen.setColor(this.vgaColor[color & 0xF]);
        this.screen.drawLine(x1, y1, x2, y2);
        this.screen.setPaintMode();
    }

    void solidPel(int x, int y, int color) {
        this.screen.setColor(this.vgaColor[color & 0xF]);
        this.screen.drawLine(x, y, x, y);
        this.updateArea(x, y, 1, 1);
    }

    void solidPel256(int x, int y, int color) {
        this.screen.setColor(this.svgaColor[color & 0xFF]);
        this.screen.drawLine(x, y, x, y);
        this.updateArea(x, y, 1, 1);
    }

    void solidRect(int x1, int y1, int width, int height, int color) {
        this.screen.setColor(this.vgaColor[color & 0xF]);
        this.screen.fillRect(x1, y1, width, height);
        this.updateArea(x1, y1, width, height);
    }

    void solidRect256(int x1, int y1, int width, int height, int color) {
        this.screen.setColor(this.svgaColor[color & 0xFF]);
        this.screen.fillRect(x1, y1, width, height);
        this.updateArea(x1, y1, width, height);
    }

    void invertRect(int x1, int y1, int width, int height, int color) {
        this.screen.setXORMode(this.vgaColor[0]);
        this.screen.setColor(this.vgaColor[color & 0xF]);
        this.screen.fillRect(x1, y1, width, height);
        this.screen.setPaintMode();
        this.updateArea(x1, y1, width, height);
    }

    void areaCopy(int xSrc, int ySrc, int xDst, int yDst, int width, int height) {
        this.screen.copyArea(xSrc, ySrc, width, height, xDst - xSrc, yDst - ySrc);
        this.updateArea(xDst, yDst, width, height);
    }

    void opaquePattern(int x1, int y1, int width, int height, int fg, int bg) {
        this.solidRect(x1, y1, width, height, bg);
        this.transPattern(x1, y1, width, height, fg);
    }

    void transPattern(int x1, int y1, int width, int height, int color) {
        int start = 0;
        byte data = 0;
        int y = 0;
        while (y < 8) {
            this.patternBuffer[y] = this.input.getByte();
            ++y;
        }
        int x2 = x1 + width - 1;
        int y2 = y1 + height - 1;
        this.screen.setColor(this.vgaColor[color & 0xF]);
        y = y1;
        while (y <= y2) {
            data = this.patternBuffer[y & 7];
            boolean fDraw = false;
            int x = x1;
            while (x <= x2) {
                if ((data & 128 >> (x & 7)) == 0) {
                    if (fDraw) {
                        this.screen.drawLine(start, y, x - 1, y);
                        fDraw = false;
                    }
                } else if (!fDraw) {
                    fDraw = true;
                    start = x;
                }
                ++x;
            }
            if (fDraw) {
                this.screen.drawLine(start, y, x2, y);
            }
            ++y;
        }
        this.updateArea(x1, y1, width, height);
    }

    void invertPattern(int x1, int y1, int width, int height) {
        this.screen.setXORMode(this.vgaColor[0]);
        this.transPattern(x1, y1, width, height, 15);
        this.screen.setPaintMode();
    }

    void monoMask(int x1, int y1, int width, int height) {
        int start = 0;
        byte data = 0;
        int x2 = x1 + width - 1;
        int y2 = y1 + height - 1;
        this.screen.setColor(this.vgaColor[0]);
        int bit = 0;
        int y = y1;
        while (y <= y2) {
            boolean fDraw = false;
            int x = x1;
            while (x <= x2) {
                if ((bit++ & 7) == 0) {
                    data = this.input.getByte();
                }
                if (data & true) {
                    if (fDraw) {
                        this.screen.drawLine(start, y, x - 1, y);
                        fDraw = false;
                    }
                } else if (!fDraw) {
                    fDraw = true;
                    start = x;
                }
                data = (byte)(data >> 1);
                ++x;
            }
            if (fDraw) {
                this.screen.drawLine(start, y, x2, y);
            }
            ++y;
        }
        this.updateArea(x1, y1, width, height);
    }

    void opaqueMono2(int x1, int y1, int width, int height, int fg, int bg) {
        this.solidRect256(x1, y1, width, height, bg);
        this.transMono2(x1, y1, width, height, fg);
    }

    void opaqueMono(int x1, int y1, int width, int height, int fg, int bg) {
        this.solidRect(x1, y1, width, height, bg);
        this.transMono(x1, y1, width, height, fg);
    }

    void transMono(int x1, int y1, int width, int height, int color) {
        int start = 0;
        byte data = 0;
        int x2 = x1 + width - 1;
        int y2 = y1 + height - 1;
        this.screen.setColor(this.vgaColor[color & 0xF]);
        int bit = 0;
        int y = y1;
        while (y <= y2) {
            boolean fDraw = false;
            int x = x1;
            while (x <= x2) {
                if ((bit++ & 7) == 0) {
                    data = this.input.getByte();
                }
                if (!(data & true)) {
                    if (fDraw) {
                        this.screen.drawLine(start, y, x - 1, y);
                        fDraw = false;
                    }
                } else if (!fDraw) {
                    fDraw = true;
                    start = x;
                }
                data = (byte)(data >> 1);
                ++x;
            }
            if (fDraw) {
                this.screen.drawLine(start, y, x2, y);
            }
            ++y;
        }
        this.updateArea(x1, y1, width, height);
    }

    void transMono2(int x1, int y1, int width, int height, int color) {
        int start = 0;
        byte data = 0;
        int x2 = x1 + width - 1;
        int y2 = y1 + height - 1;
        this.screen.setColor(this.svgaColor[color & 0xFF]);
        int bit = 0;
        int y = y1;
        while (y <= y2) {
            boolean fDraw = false;
            int x = x1;
            while (x <= x2) {
                if ((bit++ & 7) == 0) {
                    data = this.input.getByte();
                }
                if (!(data & true)) {
                    if (fDraw) {
                        this.screen.drawLine(start, y, x - 1, y);
                        fDraw = false;
                    }
                } else if (!fDraw) {
                    fDraw = true;
                    start = x;
                }
                data = (byte)(data >> 1);
                ++x;
            }
            if (fDraw) {
                this.screen.drawLine(start, y, x2, y);
            }
            ++y;
        }
        this.updateArea(x1, y1, width, height);
    }

    void opaqueColor(int x1, int y1, int width, int height) {
        byte data = 0;
        if (width * height <= 16384) {
            int index = 0;
            boolean fNible = false;
            int y = height;
            while (y != 0) {
                fNible = false;
                int x = width;
                while (x != 0) {
                    if (fNible) {
                        this.screenArray[index++] = this.vgaColorRGB[data >> 4 & 0xF];
                        fNible = false;
                    } else {
                        data = this.input.getByte();
                        this.screenArray[index++] = this.vgaColorRGB[data & 0xF];
                        fNible = true;
                    }
                    --x;
                }
                --y;
            }
            Image image = this.component.createImage(new MemoryImageSource(width, height, this.screenArray, 0, width));
            this.screen.drawImage(image, x1, y1, this);
            this.updateArea(x1, y1, width, height);
        }
    }

    void unpackedColor256(int x1, int y1, int width, int height) {
        if (width * height <= 16384) {
            int index = 0;
            int y = height;
            while (y != 0) {
                int x = width;
                while (x != 0) {
                    this.screenArray[index++] = this.svgaColorRGB[this.input.getByte() & 0xFF];
                    --x;
                }
                --y;
            }
            Image image = this.component.createImage(new MemoryImageSource(width, height, this.screenArray, 0, width));
            this.screen.drawImage(image, x1, y1, this);
            this.updateArea(x1, y1, width, height);
            this.cacheCount = 1;
        }
    }

    void packedColor256(int x1, int y1, int width, int height) {
        if (width * height <= 16384) {
            this.unpack.resetDecoder();
            int index = 0;
            int y = height;
            while (y != 0) {
                int x = width;
                while (x != 0) {
                    int data = this.unpack.decodeByte();
                    if (data < 0) {
                        return;
                    }
                    this.screenArray[index++] = this.svgaColorRGB[data];
                    --x;
                }
                --y;
            }
            Image image = this.component.createImage(new MemoryImageSource(width, height, this.screenArray, 0, width));
            this.screen.drawImage(image, x1, y1, this);
            this.invertRect(x1, y1, width, height, 15);
            this.updateArea(x1, y1, width, height);
            this.cacheCount = 1;
        }
    }

    void opaqueColorSmall(int x1, int y1, int width, int height) {
        int start = 0;
        int data = 0;
        int x2 = x1 + width - 1;
        int y2 = y1 + height - 1;
        boolean fNible = false;
        int y = y1;
        while (y <= y2) {
            int lastColor;
            fNible = false;
            if (fNible) {
                lastColor = data >> 4 & 0xF;
                fNible = false;
            } else {
                data = this.input.getByte();
                lastColor = data & 0xF;
                fNible = true;
            }
            start = x1;
            int x = x1 + 1;
            while (x <= x2) {
                int currentColor;
                if (fNible) {
                    currentColor = data >> 4 & 0xF;
                    if (currentColor != lastColor) {
                        this.screen.setColor(this.vgaColor[lastColor & 0xF]);
                        this.screen.drawLine(start, y, x - 1, y);
                        lastColor = currentColor;
                        start = x;
                    }
                    fNible = false;
                } else {
                    data = this.input.getByte();
                    currentColor = data & 0xF;
                    if (currentColor != lastColor) {
                        this.screen.setColor(this.vgaColor[lastColor & 0xF]);
                        this.screen.drawLine(start, y, x - 1, y);
                        lastColor = currentColor;
                        start = x;
                    }
                    fNible = true;
                }
                ++x;
            }
            this.screen.setColor(this.vgaColor[lastColor & 0xF]);
            this.screen.drawLine(start, y, x - 1, y);
            ++y;
        }
        this.updateArea(x1, y1, width, height);
    }

    void transColor(int x1, int y1, int width, int height) {
        int start = 0;
        byte data = 0;
        int x2 = x1 + width - 1;
        int y2 = y1 + height - 1;
        int y = y1;
        while (y <= y2) {
            data = this.input.getByte();
            int lastColor = data & 0xF;
            start = x1;
            boolean fNible = true;
            int x = x1 + 1;
            while (x <= x2) {
                int currentColor;
                if (fNible) {
                    currentColor = data >> 4 & 0xF;
                    if (currentColor != lastColor) {
                        if (lastColor != 0) {
                            this.screen.setColor(this.vgaColor[lastColor & 0xF]);
                            this.screen.drawLine(start, y, x - 1, y);
                        }
                        lastColor = currentColor;
                        start = x;
                    }
                    fNible = false;
                } else {
                    data = this.input.getByte();
                    currentColor = data & 0xF;
                    if (currentColor != lastColor) {
                        if (lastColor != 0) {
                            this.screen.setColor(this.vgaColor[lastColor & 0xF]);
                            this.screen.drawLine(start, y, x - 1, y);
                        }
                        lastColor = currentColor;
                        start = x;
                    }
                    fNible = true;
                }
                ++x;
            }
            if (lastColor != 0) {
                this.screen.setColor(this.vgaColor[lastColor & 0xF]);
                this.screen.drawLine(start, y, x - 1, y);
            }
            ++y;
        }
        this.updateArea(x1, y1, width, height);
    }

    void packedColor(int x1, int y1, int width, int height) {
        if (width * height <= 16384) {
            this.unpack.resetDecoder();
            int index = 0;
            int y = height;
            while (y != 0) {
                int x = width;
                while (x != 0) {
                    int nibble = this.unpack.decodeNibble();
                    if (nibble < 0) {
                        return;
                    }
                    this.screenArray[index++] = this.vgaColorRGB[nibble];
                    --x;
                }
                --y;
            }
            Image image = this.component.createImage(new MemoryImageSource(width, height, this.screenArray, 0, width));
            this.screen.drawImage(image, x1, y1, this);
            this.updateArea(x1, y1, width, height);
        }
    }

    void packedGray(int x1, int y1, int width, int height) {
        if (width * height <= 16384) {
            this.unpack.resetDecoder();
            int index = 0;
            int y = height;
            while (y != 0) {
                int x = width;
                while (x != 0) {
                    int pair = this.unpack.decodePair();
                    if (pair < 0) {
                        return;
                    }
                    this.screenArray[index++] = this.vgaColorGray[pair];
                    --x;
                }
                --y;
            }
            Image image = this.component.createImage(new MemoryImageSource(width, height, this.screenArray, 0, width));
            this.screen.drawImage(image, x1, y1, this);
            this.updateArea(x1, y1, width, height);
        }
    }

    void updateArea(int x, int y, int width, int height) {
        this.currentLeft = x;
        this.currentRight = x + width - 1;
        this.currentTop = y;
        this.currentBottom = y + height - 1;
    }

    boolean combineArea() {
        int tmpBottom;
        if (this.left == this.screenWidth) {
            this.left = this.currentLeft;
            this.right = this.currentRight;
            this.top = this.currentTop;
            this.bottom = this.currentBottom;
            this.currentBottom = 0;
            this.currentRight = 0;
            this.currentLeft = this.screenWidth;
            this.currentTop = this.screenHeight;
            return true;
        }
        int tmpLeft = this.currentLeft < this.left ? this.currentLeft : this.left;
        int tmpRight = this.currentRight > this.right ? this.currentRight : this.right;
        int tmpTop = this.currentTop < this.top ? this.currentTop : this.top;
        int n = tmpBottom = this.currentBottom > this.bottom ? this.currentBottom : this.bottom;
        if ((tmpRight - tmpLeft + 1) * (tmpBottom - tmpTop + 1) > this.drawImageSize) {
            this.left = tmpLeft;
            this.right = tmpRight;
            this.top = tmpTop;
            this.bottom = tmpBottom;
            this.currentBottom = 0;
            this.currentRight = 0;
            this.currentLeft = this.screenWidth;
            this.currentTop = this.screenHeight;
            return false;
        }
        this.left = tmpLeft;
        this.right = tmpRight;
        this.top = tmpTop;
        this.bottom = tmpBottom;
        this.currentBottom = 0;
        this.currentRight = 0;
        this.currentLeft = this.screenWidth;
        this.currentTop = this.screenHeight;
        return true;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return (infoflags & 0x20) == 0;
    }
}

